<?php
header('Content-Type: application/json');
require_once 'db_connection.php'; // Incluimos la conexión

// Función para enviar respuestas
function send_response($success, $message) {
    echo json_encode(['success' => $success, 'message' => $message]);
}

// Recibimos los datos de la app
$data = json_decode(file_get_contents('php://input'));

if (!isset($data->name) || !isset($data->email) || !isset($data->password)) {
    send_response(false, 'Faltan campos obligatorios.');
    exit;
}

// Limpiamos y validamos los datos
$name = $conn->real_escape_string($data->name);
$email = $conn->real_escape_string($data->email);
$password = $data->password; // La contraseña no se escapa, se hashea

// Verificamos si el email ya existe
$sql_check = "SELECT id FROM users WHERE email = ?";
$stmt_check = $conn->prepare($sql_check);
$stmt_check->bind_param("s", $email);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    send_response(false, 'El correo electrónico ya está registrado.');
    $conn->close();
    exit;
}

// Hasheamos la contraseña
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

// Insertamos el nuevo usuario con sentencias preparadas (más seguro)
$sql_insert = "INSERT INTO users (name, email, password) VALUES (?, ?, ?)";
$stmt_insert = $conn->prepare($sql_insert);
$stmt_insert->bind_param("sss", $name, $email, $hashed_password);

if ($stmt_insert->execute()) {
    send_response(true, 'Usuario registrado con éxito.');
} else {
    send_response(false, 'Error al registrar el usuario.');
}

$conn->close();
?>