package com.example.biblioteca

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.material3.Button
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.example.biblioteca.ui.theme.BibliotecaTheme

class WelcomeActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        setContent {
            BibliotecaTheme {
                Surface(modifier = Modifier.fillMaxSize()) {
                    WelcomeScreen()
                }
            }
        }
    }
}

@Composable
fun WelcomeScreen() {
    val context = LocalContext.current
    Column(
        modifier = Modifier.fillMaxSize(),
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        Text("¡Bienvenido!", style = MaterialTheme.typography.headlineLarge)

        Spacer(modifier = Modifier.height(32.dp))

        Button(onClick = { Toast.makeText(context, "Categorías próximamente", Toast.LENGTH_SHORT).show() }, modifier = Modifier.width(200.dp)) {
            Text("Categoría")
        }

        Spacer(modifier = Modifier.height(16.dp))

        Button(onClick = { Toast.makeText(context, "Libros próximamente", Toast.LENGTH_SHORT).show() }, modifier = Modifier.width(200.dp)) {
            Text("Libros")
        }

        Spacer(modifier = Modifier.height(16.dp))

        Button(onClick = { Toast.makeText(context, "Préstamos próximamente", Toast.LENGTH_SHORT).show() }, modifier = Modifier.width(200.dp)) {
            Text("Préstamos")
        }

        Spacer(modifier = Modifier.height(16.dp))

        Button(onClick = { Toast.makeText(context, "Usuarios próximamente", Toast.LENGTH_SHORT).show() }, modifier = Modifier.width(200.dp)) {
            Text("Usuarios")
        }

        Spacer(modifier = Modifier.height(48.dp))

        Button(onClick = {
            val activity = context as? Activity
            context.startActivity(Intent(context, MainActivity::class.java))
            activity?.finish() // Cierra WelcomeActivity
        }) {
            Text("Regresar a Inicio de Sesión")
        }
    }
}

@Preview(showBackground = true)
@Composable
fun WelcomeScreenPreview() {
    BibliotecaTheme {
        WelcomeScreen()
    }
}
